/* await-timeout v0.6.0 by Vitaliy Potapov */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = global || self, global.Timeout = factory());
}(this, function () { 'use strict';

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function promiseFinally(promise, fn) {
    var success = function success(result) {
      fn();
      return result;
    };

    var error = function error(e) {
      fn();
      return Promise.reject(e);
    };

    return Promise.resolve(promise).then(success, error);
  }
  /**
   * Converts any value to Error.
   * @param {*} value
   * @returns {Error}
   */

  function toError(value) {
    value = typeof value === 'function' ? value() : value;
    return typeof value === 'string' ? new Error(value) : value;
  }

  var Timeout =
  /*#__PURE__*/
  function () {
    function Timeout() {
      _classCallCheck(this, Timeout);

      this._id = null;
      this._delay = null;
    }

    _createClass(Timeout, [{
      key: "set",
      value: function set(delay) {
        var _this = this;

        var rejectReason = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        return new Promise(function (resolve, reject) {
          _this.clear();

          var fn = rejectReason ? function () {
            return reject(toError(rejectReason));
          } : resolve;
          _this._id = setTimeout(fn, delay);
          _this._delay = delay;
        });
      }
    }, {
      key: "wrap",
      value: function wrap(promise, delay) {
        var _this2 = this;

        var rejectReason = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
        var wrappedPromise = promiseFinally(promise, function () {
          return _this2.clear();
        });
        var timer = this.set(delay, rejectReason);
        return Promise.race([wrappedPromise, timer]);
      }
    }, {
      key: "clear",
      value: function clear() {
        if (this._id) {
          clearTimeout(this._id);
        }
      }
    }, {
      key: "id",
      get: function get() {
        return this._id;
      }
    }, {
      key: "delay",
      get: function get() {
        return this._delay;
      }
    }]);

    return Timeout;
  }();

  Timeout.set = function (delay, rejectReason) {
    return new Timeout().set(delay, rejectReason);
  };

  Timeout.wrap = function (promise, delay, rejectReason) {
    return new Timeout().wrap(promise, delay, rejectReason);
  };

  return Timeout;

}));
